#include "Deck.h"

Deck::Deck(float X0, float Y0): cardStack( X0, Y0)
{
    TEST = false;
}

Deck::~Deck()
{
    // dtor
}

void Deck::draw(void)
{
    card::pWndw->Draw( spr );
}

bool Deck::hitLt_dn(void)
{
    return mo;
}

bool Deck::mseOver(void)
{
    mo = false;

    float f_mseY = static_cast<float>( r_mseY );
    if( f_mseY < y0 - card::h/2.0f ) return false;
    if( f_mseY > y0 + card::h/2.0f ) return false;

    float f_mseX = static_cast<float>( r_mseX );
    if( f_mseX < x0 - card::w/2.0f ) return false;
    if( f_mseX > x0 + card::w/2.0f ) return false;

    mo = true;

    return true;
}// end of mseOver()

void Deck::addCard( card newCard )
{
    newCard.spr.SetPosition( x0, y0 );
    cards.push_back( newCard );
    ++Ncards;
}

card Deck::removeCard(void)
{
    card card_out;
    card_out.spr = mv_spr;

    if( !cards.empty() )
    {
        if( TEST )
        {
            card_out = removeTopCard();
        }
        else// normal random card deal
        {
            // generate an iterator to a random card
            size_t rIdx = rand()%cards.size();
            std::list<card>::iterator it = cards.begin();
            for( size_t x = 0; x<rIdx; ++x) ++it;

            card_out = *it;
            cards.erase( it );
            --Ncards;
        }

    }

    return card_out;
}


card Deck::removeTopCard(void)
{
    card card_out = cards.front();
    cards.pop_front();
    --Ncards;
    return card_out;
}

bool Deck::sendCard(cardStack& r_dest)
{
    if( !cards.empty() )
    {
        if( !mv_Leg.inUse )// start next card deal
        {
            mv_card = removeCard();
            mv_Leg.pSprite = &mv_spr;
            mv_Leg.INIT( x0, y0, r_dest.xf, r_dest.y0, mv_speed );
            mv_Leg.tLeg = 0.0f;
            mv_Leg.inUse = true;
        }
    }
    else
        return false;

    mv_Leg.move();

    if( !mv_Leg.inUse )
        r_dest.addCard( mv_card );

    return mv_Leg.inUse;
}
