#include "Hand.h"

Hand::Hand(float X0, float Y0): cardStack( X0, Y0 )
{
    held = false;
    cardsSelected = false;
    grabIdx = releaseIdx = 0;
}

Hand::~Hand()
{
    //dtor
}

void Hand::draw(void)
{
    for( std::list<card>::iterator it = cards.begin(); it != cards.end(); ++it )
    {
		    it->draw();
    }

    if( mo )
    {
        float xLt = x0 - card::w/2.0f + dx*(float)currIdx + 0.5f*dx;
        sf::Shape Line = sf::Shape::Line( xLt, y0-card::h/2.0f, xLt, y0+card::h/2.0f, 3.0f, sf::Color(128,128,128,128) );
        card::pWndw->Draw( Line );
    }

    if( held )
    {
        float xLt = x0 - card::w/2.0f + dx*(float)grabIdx + 0.5f*dx;
        sf::Shape Line = sf::Shape::Line( xLt, y0-card::h/2.0f, xLt, y0+card::h/2.0f, 3.0f, sf::Color(0,255,0,128) );
        card::pWndw->Draw( Line );
    }

    if( cardsSelected )
    {
     //   for( auto iit = selectedList.begin{}; iit != selectedList.end(); ++iit )
        for( size_t i = 0; i < selectedList.size(); ++i )
        {
            float xLt = selectedList[i]->spr.GetPosition().x - card::w/2.0f + 0.5f*dx;
            sf::Shape Line = sf::Shape::Line( xLt, y0-card::h/2.0f, xLt, y0+card::h/2.0f, 3.0f, sf::Color(0,0,255,128) );
            card::pWndw->Draw( Line );
        }
    }
}

bool Hand::mseOver(void)
{
    float f_mseY = static_cast<float>( r_mseY );
    mo = false;

    if( f_mseY < y0 - card::h/2.0f )// mse is above the stack
    {
        held = false;
        return false;
    }
    if( f_mseY > y0 + card::h/2.0f )// mse is below the stack
    {
        held = false;
        return false;
    }

    float xLt = x0 - card::w/2.0f;
    if( held ) xLt -= dx;
    float xRt = xf + card::w/2.0f;
    float f_mseX = static_cast<float>( r_mseX );

    if( f_mseX < xLt )// mse is left of the stack
    {
        held = false;
        return false;
    }
    if( f_mseX > xRt )// mse is right of the stack
    {
        held = false;
        return false;
    }

    currIdx = static_cast<int>( (dx + f_mseX - x0 + card::w/2.0f)/dx ) - 1;
    if( currIdx > Ncards - 1 ) currIdx = Ncards - 1;
    mo = true;

    return true;
}// end of mseOver()

bool Hand::hitLt_dn(void)
{
    if( mo )
    {
        held = true;
        grabIdx = currIdx;
  //      std::cout << "grabIdx = " << grabIdx << std::endl;
    }
    return mo;
}

void Hand::hitLt_up(void)
{
    held = false;
    int i=0;// for looping

    if( mo )
    {
        releaseIdx = currIdx;
  //      std::cout << "releaseIdx = " << releaseIdx << std::endl;

        if( releaseIdx != grabIdx )// just rearraning cards in hand
            moveCardInHand();
        else// cards are being selected for play / discard
        {
            cardsSelected = true;
            std::list<card>::iterator it = cards.begin();
            for( i=0; i<releaseIdx; ++i) ++it;// iterator to selected card

            // or was that a de-selection?
            size_t x = 0;
            for( x=0; x < selectedList.size(); ++x)// search for this iterator in selectedList
                if( it == selectedList[x] ) break;

            if( x < selectedList.size() )// it was found!
            {
                selectedList.erase( selectedList.begin() + x );// erase it
    //            std::cout << "UN-selected the " << it->face << std::endl;
                if( selectedList.empty() ) cardsSelected = false;
            }
            else// that WAS a selection
            {
                selectedList.push_back( it );
     //           std::cout << "selected the " << it->face << std::endl;
            }
        }
    }
}// end of hitLt_up()

/*
void Hand::hitLt_up(void)
{
    held = false;
    int i=0;// for looping

    if( mo )
    {
        releaseIdx = currIdx;
        std::cout << "releaseIdx = " << releaseIdx << std::endl;

        if( releaseIdx != grabIdx )// just rearraning cards in hand
            moveCardInHand();
        else// cards are being selected for play / discard
        {
            cardsSelected = true;
            std::list<card>::iterator it = cards.begin();
            for( i=0; i<releaseIdx; ++i) ++it;
            selectedList.push_back( it );
            std::cout << "selected the " << it->face << std::endl;
        }

    }
}// end of hitLt_up()
*/

void Hand::moveCardInHand(void)
{
    bool repos = false;
    int i = 0;// for looping

    // move card within stack
    std::list<card>::iterator insertIt = cards.begin();
    for( i=0; i<=releaseIdx; ++i) ++insertIt;

    std::list<card>::iterator deleteIt = cards.begin();
    for( i=0; i<grabIdx; ++i) ++deleteIt;

    card mv_card = *deleteIt;

    if( releaseIdx < grabIdx - 1 )// move left
    {
        repos = true;
        cards.erase( deleteIt );
        cards.insert( insertIt, mv_card );
    }

    if( releaseIdx > grabIdx )// move right
    {
        repos = true;
        cards.insert( insertIt, mv_card );
        cards.erase( deleteIt );
    }

    // reassign card positions
    if( repos )
        regroupCards();
}

void Hand::regroupCards(void)
{
    float x = x0;
    std::list<card>::iterator it = cards.begin();
    for( ; it != cards.end(); ++it )
    {
        it->spr.SetPosition( x, y0 );
        x += dx;
    }
    xf = x;
}

card Hand::removeCard(void)
{
    card card_out = cards.front();// safegaurd. card_out should be valid
    if( !selectedList.empty() )
    {
        card_out = *selectedList.front();
        cards.erase( selectedList.front() );
        selectedList.erase( selectedList.begin() );
        --Ncards;
        xf -= dx;
        if( selectedList.empty() )
            cardsSelected = false;
    }
    return card_out;
}

bool Hand::sendCard(cardStack& r_dest)
{
    if( !mv_Leg.inUse )// start next card deal
    {
        mv_card = removeCard();
        mv_Leg.pSprite = &mv_card.spr;
        mv_Leg.tLeg = 0.0f;
        mv_Leg.inUse = true;
        mv_Leg.INIT( mv_card.spr.GetPosition().x, mv_card.spr.GetPosition().y, r_dest.xf, r_dest.y0, mv_speed );
    }

    // move the card
    mv_Leg.move();

    if( !mv_Leg.inUse )// end this card deal
    {
        r_dest.addCard( mv_card );
        regroupCards();

        if( selectedList.empty() )
            return false;
        else
            return true;
    }
    return true;// dealLeg still inUse !
}

/*
card Hand::removeCard(void)
{
    card card_out = cards.front();// safegaurd. card_out should be valid
    if( !selectedList.empty() )
    {
        card_out = *selectedList.back();
        cards.erase( selectedList.back() );
        selectedList.pop_back();
        --Ncards;
        xf -= dx;
        if( selectedList.empty() )
            cardsSelected = false;
    }
    return card_out;
}

bool Hand::sendCard(cardStack& r_dest)
{
    if( !mv_Leg.inUse )// start next card deal
    {
        mv_card = removeCard();
        selectedList.clear();
        cardsSelected = false;
        mv_Leg.pSprite = &mv_card.spr;
        mv_Leg.tLeg = 0.0f;
        mv_Leg.inUse = true;
        mv_Leg.INIT( mv_card.spr.GetPosition().x, mv_card.spr.GetPosition().y, r_dest.xf, r_dest.y0, mv_speed );
    }

    // move the card
    mv_Leg.move();

    if( !mv_Leg.inUse )// end this card deal
    {
        r_dest.addCard( mv_card );
        regroupCards();
        return false;
    }
    return true;// dealLeg still inUse !
}
*/
