#ifndef HAND_H
#define HAND_H

#include "cardStack.h"

typedef list<card>::iterator lc_it;


class Hand : public cardStack
{
    public:

    bool held;
    int currIdx;// maintained by mseOver()
    int grabIdx;// = currIdx when held = true in hitLt_dn()
    int releaseIdx;// = currIdx when held = false in hitLt_up()

    bool cardsSelected;
  //  std::list< std::list<card>::iterator > selectedList;
    vector< list<card>::iterator > selectedList;


    // functions
    virtual void draw(void);
    virtual bool mseOver(void);
    virtual bool hitLt_dn(void);
    card removeCard(void);
    virtual bool sendCard(cardStack& r_dest);

    void hitLt_up(void);// unique to this class
    void moveCardInHand(void);// helper for hitLt_up()
    void regroupCards(void);

    Hand(float X0, float Y0);
    ~Hand();
};

#endif // HAND_H
