#ifndef CARDSTACK_H
#define CARDSTACK_H

#include <SFML/Graphics.hpp>
#include<list>
#include<vector>
#include <iostream>
#include "card.h"
#include "linLeg.h"

using std::list;
using std::vector;
using std::cout;
using std::endl;

class cardStack
{
    public:
    static float dx;
    static const int& r_mseX;
    static const int& r_mseY;
    static linLeg mv_Leg;// for animated card moves
    static card mv_card;// temp for card in transit on mv_Leg
    static float mv_speed;


    list<card> cards;
    int Ncards;
    float x0;// center of leftmost card in the stack
    float xf;// center of rightmost card in the stack
    float y0;

    bool mo;


    // functions
    virtual void addCard( card newCard );// redefined in the Deck class

    virtual card removeCard(void) = 0;// defined differently for each class
    virtual void draw(void) = 0;
    virtual bool mseOver(void) = 0;
    virtual bool hitLt_dn(void) = 0;
    virtual bool sendCard(cardStack& r_dest) = 0;

    void returnCards( cardStack& r_dest );

    cardStack(float X0, float Y0);
    virtual ~cardStack();
};

#endif // CARDSTACK_H
