#include "discardStack.h"

discardStack::discardStack(float X0, float Y0): cardStack( X0, Y0)
{
    NcardsToSend = currIdx = 0;
}

discardStack::~discardStack()
{

}

void discardStack::draw(void)
{
    for( std::list<card>::iterator it = cards.begin(); it != cards.end(); ++it )
        it->draw();

    if( mo )
    {
        float xLt = x0 - card::w/2.0f + dx*(float)currIdx + 0.5f*dx;
        sf::Shape Line = sf::Shape::Line( xLt, y0-card::h/2.0f, xLt, y0+card::h/2.0f, 3.0f, sf::Color(128,128,128,128) );
        card::pWndw->Draw( Line );
    }
}

bool discardStack::mseOver(void)
{
    float f_mseY = static_cast<float>( r_mseY );
    mo = false;

    if( f_mseY < y0 - card::h/2.0f )// mse is above the stack
        return false;

    if( f_mseY > y0 + card::h/2.0f )// mse is below the stack
        return false;


    float xLt = x0 - card::w/2.0f;
    float xRt = xf + card::w/2.0f;
    float f_mseX = static_cast<float>( r_mseX );

    if( f_mseX < xLt )// mse is left of the stack
        return false;

    if( f_mseX > xRt )// mse is right of the stack
        return false;

    currIdx = static_cast<int>( (dx + f_mseX - x0 + card::w/2.0f)/dx ) - 1;
    if( currIdx > Ncards - 1 ) currIdx = Ncards - 1;
    mo = true;

    return true;
}// end of mseOver()

bool discardStack::hitLt_dn(void)
{
    if( mo )
    {
  //      std::cout << "discard currIdx = " << currIdx << std::endl;
        NcardsToSend = Ncards - currIdx;
    }
    return mo;
}

card discardStack::removeCard(void)
{
    card card_out = cards.back();
    cards.pop_back();
    --Ncards;
    xf -= dx;
    return card_out;
}

bool discardStack::sendCard(cardStack& r_dest)
{
    static int cnt = 1;

    if( !mv_Leg.inUse )// start next card deal
    {
        mv_card = removeCard();
        mv_Leg.pSprite = &mv_card.spr;
        mv_Leg.tLeg = 0.0f;
        mv_Leg.inUse = true;
        mv_Leg.INIT( xf, y0, r_dest.xf, r_dest.y0, mv_speed );
    }

    // move the card
    mv_Leg.move();

    if( !mv_Leg.inUse )// end this card deal
    {
        if( cnt < NcardsToSend )
        {
            r_dest.addCard( mv_card );
            ++cnt;
            return true;
        }
        r_dest.addCard( mv_card );
        cnt = 1;
        return false;
    }
    return true;// dealLeg still inUse !
}
