#include <SFML/Graphics.hpp>
#include <iostream>
#include <fstream>
#include<string>
#include<list>
#include<vector>
#include<algorithm>
#include<functional>
#include<sstream>
#include<ctime>// for seeding random #'s

#include"card.h"
#include "discardStack.h"
#include "playStack.h"
#include "Hand.h"
#include "Deck.h"
#include "linLeg.h"
#include "buttonRectDrawn.h"
#include "okBox.h"

using std::cout;
using std::endl;
using std::list;
using std::vector;
using std::sort;

int mseX = 0, mseY = 0;// maintain mouse coords.
const int& cardStack::r_mseX = mseX;
const int& cardStack::r_mseY = mseY;
const int& button::r_mseX = mseX;
const int& button::r_mseY = mseY;

// okBox objects
okBox alert1(300.0f, 250.0f, "Only one card may be discarded.");
okBox alert2(300.0f, 250.0f, "Illegal play!");
okBox* p_alert = &alert1;

// buttons
buttonRectDrawn mv_Butt( 'm', 30, 300, 30, 30 );

// messages
sf::String msg_DRAW[2];// for prompting user play
sf::String msg_DISCARD[2];// for prompting user play
sf::String msg_PAUSE;// shows if game is paused

sf::String msg_score[2];// for the full time game total display
sf::String msg_Ntot[2];// for the full time game total display
sf::String msg_CDfNH;// "CLICK DECK for NEXT HAND"
sf::String msg_CARDSLEFT;// # of cards left in the deck
sf::String msg_Ncards;
// for the score box
sf::String msg_sth;// "scores this hand"
sf::String msg_pdt;// "plays  deduct  total"
sf::String msg_top;// "top"
sf::String msg_Npt, msg_Ndt, msg_Ntt;// top set of #'s
sf::String msg_bottom;// "bottom"
sf::String msg_Npb, msg_Ndb, msg_Ntb;// bottom set of #'s
sf::Shape scoreBoxBK;// the score box background

// the card images
sf::Image cardImg[52];
sf::Image backImg;

// cardStack objects
Deck deck( 200.0f, 300.0f );

const int Nhands = 2;
Hand hand[] = { Hand( 100.0f, 100.0f ), Hand( 100.0f, 520.0f ) };
discardStack discardPile( 300.0f, 300.0f );
list<playStack> playList[2];// one list of playStacks for each player

cardStack* p_src = &deck;// assigned in LBUTTDN. Used in frame logic
cardStack* p_dest = hand+1;

//*** for logic flow ***
bool beginHand = true;

int turnPhase = 0;// 0 = begin hand, 1 = draw, 2 = play/discard
bool go = false;// trigger for next turn phase. = true in LBUTTDN. false in frame logic.
bool paused = false;// toggle with key = 'p'

int turn = 1;
int playScore[2] = {0};
int totalScore[2] = {0};
int deductFromHand = 0;// from cards left in the one players hand

// functions
bool LoadImages(void);
bool LoadImages( const char* fname_CardList );// load a test game from a file
bool HandleEvent(const sf::Event& rEvent, sf::RenderWindow& rApp );// returns false if App is to close, true otherwise
bool dealHands(void);
void INITmessages(void);
void INITforScoreBox(void);
void scoreHands(void);// called at end of each hand
void drawScoreBox( sf::RenderWindow& rApp );
void gameHit_dn(void);
void gameLogic(void);
void gameDraw(sf::RenderWindow& rApp);
bool discardJudge(void);// these judge functions
bool playJudge(void);// are called from within gameHit_dn();
bool twoCardJudge( vector<card>& Cards );// written to work for N cards but testing on 2 card plays for now
bool isAceLowStraight(vector<card>& Cards, int N);// Called by playJudge(). Horrible solution. Come up with better!!

// functions, etc. for comp. plays
struct sf_pair// used to construct copy of hands data for play searches
{
    char suit;
    int face;
    sf_pair(char Suit, int Face): suit(Suit), face(Face) {}
    bool operator<(const sf_pair& b) const { return face < b.face; }
};

bool c_findPlay( const discardStack* p_ds = NULL );
int c_scorePlay( vector<sf_pair>& handVec );
bool c_find_3kind( vector<sf_pair>& handVec );
bool c_find_3straight( vector<sf_pair>& handVec );
bool c_find_addToExist( vector<sf_pair>& handVec );
bool c_makePlay(void);// return assigned to c_start
bool c_drawCards(void);// return assigned to c_start
bool c_discard(void);// return assigned to c_start
list<card>::iterator c_findLoRankCard(void);
bool c_playFound = false;
bool c_discarded = false;
vector<int> idxVec;
float c_psX = 500.0f;
float c_psY = 50.0f;
float c_dpsX = 150.0f;
float c_dpsY = 40.0f;
int delayCnt = 20;
int delayIdx = 0;
bool c_start = false;

template<class T>
float to_sf_string(sf::String& strArg, T x);// returns position of end of strArg

int main()
{
 //   char ans = 'r';
 //   cout << "Play regular or test game? (r/t): "; std::cin >> ans;

 //   if( ans == 'r' )
 //   {
        if( !LoadImages() )
            return 1;// return error code!
 //   }
//	else
//	{
//	    if( !LoadImages( "testGame.txt" ) )
//            return 1;// return error code!
//	}

    INITmessages();
    INITforScoreBox();
    cardStack::mv_speed = 40.0f;
    srand((unsigned)time(0));// comment out for repeatable lineup sequences

    // Create the main rendering window
    sf::RenderWindow App(sf::VideoMode(800, 600, 32), "SFML Graphics");
	App.UseVerticalSync(true);
    button::pWndw = &App;
    card::pWndw = &App;
    Leg::pWndw = &App;

    // TEST CODE
//    alert1.open = true;

	// local vars
	float frPeriod = 1.0f/30.0f;// for 30 fps
	sf::Clock frClock; frClock.Reset();
//	const sf::Input& Input = App.GetInput();

    // Start game loop
    while (App.IsOpened())
    {
        // Process events
        sf::Event Event;
        while (App.GetEvent(Event))
        {
            if( !HandleEvent(Event, App) )
				App.Close();
        }

        // Clear the screen
		App.Clear( sf::Color(0, 50, 100) );// Color bkgd

		// assign images to sprites
		if( frClock.GetElapsedTime() > frPeriod && !paused )
		{
			frClock.Reset();

			if( beginHand )
			{
			    beginHand = dealHands();
			    if( !beginHand )
			    {
			        cardStack::mv_speed = 30.0f;// slow the card speeds a bit
                    turnPhase = 1;
                    discardPile.mseOver();// update in case mouse is parked over the discardPile
                    // comp play
                    if( turn == 0 )
                        c_start = c_drawCards();
			    }
			}

			// timed delay for comp. moves
			if( c_start )
			{
			    ++delayIdx;
			    if( delayIdx >= delayCnt )// time's up
			    {
			        delayIdx = 0;
			        c_start = false;
			        go = true;
			    }
			}

            if( go && p_src && p_dest )
                gameLogic();

		}// end of frame logic

		// draw stuff
		gameDraw( App );


        // Display window contents on screen
        App.Display();
    }

    return EXIT_SUCCESS;
}// end of main()

void gameLogic(void)
{
    // draw phase of turn
    if( turnPhase == 1 )// && go )
    {
        go = p_src->sendCard( *p_dest );
        if( !go )
        {
            to_sf_string( msg_Ncards, deck.Ncards );// update the displayed # of cards left in deck
            turnPhase = 2;// time to play/discard

            // comp play
            if( turn == 0 )
            {
                if( c_findPlay() )
                    c_start = c_playFound = c_makePlay();
                else
                    c_start = c_discarded = c_discard();
            }
        }
    }

    // play / discard phase of turn
    if( turnPhase == 2 && go )
    {
        go = p_src->sendCard( *p_dest );
        if( !go )
        {
            if( p_dest == &discardPile )// play is over
            {
                if( p_src->cards.empty() )// player "went out". Hand is over
                {
                    turnPhase = 3;
                    scoreHands();
                    c_psX = 500.0f; c_psY = 50.0f;// reset c's playstack position
                    for(int i=0; i<13; ++i) playStack::faceCnt[i] = 0;// reset the face counts
                }
                else// play goes on
                {
                    turn = (1 + turn)%2;// change turn
                    turnPhase = 1;// time to draw
                    discardPile.mseOver();

                    // comp play
                    if( turn == 0 )
                        c_start = c_drawCards();
                }
            }
            else if( turn == 0 )// comps continued play
            {
                if( c_findPlay() )
                    c_start = c_playFound = c_makePlay();
                else// if( !c_discarded )
                    c_start = c_discarded = c_discard();
            }

        }
    }// end of turnPhase 2
    return;
}// end of gameLogic()

void gameDraw(sf::RenderWindow& rApp)
{
    deck.draw();
    hand[0].draw();
    hand[1].draw();
    discardPile.draw();
    for( list< playStack >::iterator it = playList[0].begin(); it != playList[0].end(); ++it )
        it->draw();

    for( list< playStack >::iterator it = playList[1].begin(); it != playList[1].end(); ++it )
        it->draw();


    if( turnPhase == 1 ) rApp.Draw( msg_DRAW[turn] );
    if( turnPhase == 2 ) rApp.Draw( msg_DISCARD[turn] );
    if( cardStack::mv_Leg.inUse ) cardStack::mv_Leg.draw();

    rApp.Draw( msg_score[0] ); rApp.Draw( msg_Ntot[0] );
    rApp.Draw( msg_score[1] ); rApp.Draw( msg_Ntot[1] );
    rApp.Draw( msg_CARDSLEFT ); rApp.Draw( msg_Ncards );

    if( turnPhase == 3 )// hand has ended
    {
        rApp.Draw( msg_CDfNH );
        drawScoreBox( rApp );
    }

    if( okBox::open && p_alert )
        p_alert->draw();

//    mv_Butt.draw();
    if( paused ) rApp.Draw( msg_PAUSE );

    return;
}// end of gameDraw()

bool dealHands(void)
{
    static int cnt = 0;
    static int hIdx = 0;
    static bool busy = false;// waiting for a card move to complete
    int N = 7;

    // deal 7 cards to each hand
    if( cnt < N )
    {
        busy = deck.sendCard( hand[ hIdx ] );
        if( !busy )
        {
            to_sf_string( msg_Ncards, deck.Ncards );

            if( hIdx == 1 ) ++cnt;
            hIdx = (1 + hIdx)%2;// alternate hands
            return true;
        }
        return true;
    }

    // deal 1 card to the discardPile
    busy = deck.sendCard( discardPile );
    if( !busy )// end this card deal
    {
        to_sf_string( msg_Ncards, deck.Ncards );

        cnt = 0;// reset values of static variables
        hIdx = 0;
        return false;// all animations complete
    }
    return true;// dealLeg still inUse !
}// end of dealHands()

void INITmessages(void)
{
    msg_CDfNH.SetText( "CLICK DECK\n      for\nNEXT HAND" );
    msg_CDfNH.SetPosition( 50.0f, 270.0f );
    msg_CDfNH.SetFont( sf::Font::GetDefaultFont() );
    msg_CDfNH.SetColor( sf::Color(255,255,255) );
    msg_CDfNH.SetSize( 14.0 );

    // upper set
    msg_DRAW[0].SetText( "Draw" );
	msg_DRAW[0].SetPosition( 150.0f, 180.0f );
    msg_DRAW[0].SetFont( sf::Font::GetDefaultFont() );
	msg_DRAW[0].SetColor( sf::Color(255,255,255) );
	msg_DRAW[0].SetSize( 16.0 );

	msg_DISCARD[0].SetText( "Make play or discard" );
	msg_DISCARD[0].SetPosition( 150.0f, 180.0f );
    msg_DISCARD[0].SetFont( sf::Font::GetDefaultFont() );
	msg_DISCARD[0].SetColor( sf::Color(255,255,255) );
	msg_DISCARD[0].SetSize( 16.0 );

	// lower set
    msg_DRAW[1].SetText( "Draw" );
	msg_DRAW[1].SetPosition( 150.0f, 400.0f );
    msg_DRAW[1].SetFont( sf::Font::GetDefaultFont() );
	msg_DRAW[1].SetColor( sf::Color(255,255,255) );
	msg_DRAW[1].SetSize( 16.0 );

	msg_DISCARD[1].SetText( "Make play or discard" );
	msg_DISCARD[1].SetPosition( 150.0f, 400.0f );
    msg_DISCARD[1].SetFont( sf::Font::GetDefaultFont() );
	msg_DISCARD[1].SetColor( sf::Color(255,255,255) );
	msg_DISCARD[1].SetSize( 16.0 );

	msg_CARDSLEFT.SetText( "Cards left: " );
	msg_CARDSLEFT.SetPosition( 150.0f, 370.0f );
	msg_CARDSLEFT.SetFont( sf::Font::GetDefaultFont() );
	msg_CARDSLEFT.SetColor( sf::Color(255,255,255) );
	msg_CARDSLEFT.SetSize( 16.0 );
    msg_Ncards = msg_CARDSLEFT; msg_Ncards.SetX( msg_CARDSLEFT.GetRect().Right + 15.0f );

    msg_PAUSE.SetText( "PAUSE" );
    msg_PAUSE.SetPosition( 375.0f, 560.0f );
    msg_PAUSE.SetFont( sf::Font::GetDefaultFont() );
    msg_PAUSE.SetColor( sf::Color(255,0,0) );
    msg_PAUSE.SetSize( 25.0 );

    // button labels
    mv_Butt.INITlabel( "off", 14, sf::Color(255,0,0), 'c' );

	return;
}

void INITforScoreBox(void)
{
    // the full time score displays
    msg_score[0].SetText( "score = " );
	msg_score[0].SetPosition( 150.0f, 20.0f );
    msg_score[0].SetFont( sf::Font::GetDefaultFont() );
	msg_score[0].SetColor( sf::Color(255,255,255) );
	msg_score[0].SetSize( 16.0 );
	msg_score[1] = msg_score[0];
	msg_score[1].SetPosition( 150.0f, 570.0f );

	msg_Ntot[0] = msg_score[0];
	msg_Ntot[0].SetText( "0" );
	msg_Ntot[0].SetX( 210.0f );
	msg_Ntot[1] = msg_score[1];
	msg_Ntot[1].SetText( "0" );
	msg_Ntot[1].SetX( 210.0f );


	// the background rectangle
	float xlt = 85.0f, yt = 100.0f;//400.0f;
	scoreBoxBK = sf::Shape::Rectangle( xlt, yt, xlt + 230.0f, yt + 90.0f, sf::Color(0,200,0), 4.f, sf::Color(100,0,0));

	msg_sth.SetText( "scores this hand" );
	msg_sth.SetPosition( xlt + 50.0f, yt - 30.0f );
    msg_sth.SetFont( sf::Font::GetDefaultFont() );
	msg_sth.SetColor( sf::Color(255,255,255) );
	msg_sth.SetSize( 18.0 );

	msg_pdt.SetText( "plays    deduct    total" );
	msg_pdt.SetPosition( xlt + 75.0f, yt + 10.0f );
    msg_pdt.SetFont( sf::Font::GetDefaultFont() );
	msg_pdt.SetColor( sf::Color(0,0,0) );
	msg_pdt.SetSize( 14.0 );

	msg_top.SetText( "   top" );
	msg_top.SetPosition( xlt + 10.0f, yt + 30.0f );
    msg_top.SetFont( sf::Font::GetDefaultFont() );
	msg_top.SetColor( sf::Color(0,0,0) );
	msg_top.SetSize( 14.0 );
	msg_Npt = msg_Ndt = msg_Ntt = msg_top;
	msg_Npt.SetText( "125" ); msg_Npt.SetX( xlt + 75.0f );
	msg_Ndt.SetText( "30" ); msg_Ndt.SetX( xlt + 130.0f );
	msg_Ntt.SetText( "95" ); msg_Ntt.SetX( xlt + 180.0f );

	msg_bottom.SetText( "bottom" );
	msg_bottom.SetPosition( xlt + 10.0f, yt + 50.0f );
    msg_bottom.SetFont( sf::Font::GetDefaultFont() );
	msg_bottom.SetColor( sf::Color(0,0,0) );
	msg_bottom.SetSize( 14.0 );
	msg_Npb = msg_Ndb = msg_Ntb = msg_bottom;
	msg_Npb.SetText( "75" ); msg_Npb.SetX( xlt + 75.0f );
	msg_Ndb.SetText( " " ); msg_Ndb.SetX( xlt + 130.0f );
	msg_Ntb.SetText( "75" ); msg_Ntb.SetX( xlt + 180.0f );

    return;
}// end of INITforScoreBox()

void scoreHands(void)// called at end of each hand
{
    std::list<playStack>::iterator plIt;
    std::list<card>::iterator clIt;

    playScore[0] = playScore[1] = 0;

    // score the plays
    for( int i=0; i<2; ++i)
        for( plIt = playList[i].begin(); plIt != playList[i].end(); ++plIt )
            for( clIt = plIt->cards.begin(); clIt != plIt->cards.end(); ++clIt )
            {
                if( clIt->face == 14 )// card is an Ace
                {
                    playScore[i] += 15;
                }
                else if( clIt->face < 10 )// 1 - 9
                {
                    playScore[i] += 5;
                    if( clIt->face == 1 ) clIt->face = 14;// return to high ace
                }
                else// 10, J, Q, K
                    playScore[i] += 10;
            }

    // deduct for cards left in the one players hand
    deductFromHand = 0;
    int hIdx = 0;// try hand[0]
    if( hand[hIdx].cards.empty() )// oops! Other hand.
        hIdx = 1;

    for( clIt = hand[hIdx].cards.begin(); clIt != hand[hIdx].cards.end(); ++clIt )
    {
        int fv = clIt->face;

        if( fv == 14 )// card is an Ace
            deductFromHand += 15;
        else if( clIt->face < 10 )// 2 - 9
            deductFromHand += 5;
        else// 10, J, Q, K
            deductFromHand += 10;
    }
    // find totals
    totalScore[0] += playScore[0];
    totalScore[1] += playScore[1];
    totalScore[hIdx] -= deductFromHand;

    // get the msg_N's text assigned
    to_sf_string( msg_Ntot[0], totalScore[0] );
    to_sf_string( msg_Ntot[1], totalScore[1] );

    to_sf_string( msg_Npt, playScore[0] );
    to_sf_string( msg_Npb, playScore[1] );

    playScore[hIdx] -= deductFromHand;
    to_sf_string( msg_Ntt, playScore[0] );
    to_sf_string( msg_Ntb, playScore[1] );

    float yt = 0.0f;// top of scoreBoxBK
    if( hIdx == 0 )// the one with the non-zero deduct
    {
        to_sf_string( msg_Ndt, deductFromHand );// top player
        msg_Ndb.SetText( " " );
        yt = 430.0f;
    }
    else
    {
        to_sf_string( msg_Ndb, deductFromHand );// bottom player
        msg_Ndt.SetText( " " );
        yt = 100.0f;
    }

    scoreBoxBK.SetY( yt - 100.0f );// fudge factor
    msg_sth.SetY( yt - 30.0f );
    msg_pdt.SetY( yt + 10.0f);
    msg_top.SetY( yt + 30.0f ); msg_Npt.SetY( yt + 30.0f ); msg_Ndt.SetY( yt + 30.0f ); msg_Ntt.SetY( yt + 30.0f );
    msg_bottom.SetY( yt + 50.0f ); msg_Npb.SetY( yt + 50.0f ); msg_Ndb.SetY( yt + 50.0f ); msg_Ntb.SetY( yt + 50.0f );

    return;
}// end of scoreHand()

void drawScoreBox( sf::RenderWindow& rApp )
{
    rApp.Draw( scoreBoxBK );
    rApp.Draw( msg_sth );
    rApp.Draw( msg_pdt );
    rApp.Draw( msg_top );
    rApp.Draw( msg_bottom );
    rApp.Draw( msg_Npt );
    rApp.Draw( msg_Ndt );
    rApp.Draw( msg_Ntt );
    rApp.Draw( msg_Npb );
    rApp.Draw( msg_Ndb );
    rApp.Draw( msg_Ntb );

    return;
}

bool HandleEvent(const sf::Event& rEvent, sf::RenderWindow& rApp )
{
    list< playStack >::iterator plIt;// for looping

	// Close window : exit
    if (rEvent.Type == sf::Event::Closed)
		return false;

	if(rEvent.Type == sf::Event::KeyPressed)
	{
		switch( rEvent.Key.Code )
		{
			case sf::Key::Escape:
				return false;

            case sf::Key::P:
                paused = !paused;// toggle value
                return true;

            case sf::Key::F1:
            {
                sf::Image Screen = rApp.Capture();
                Screen.SaveToFile("screenshot.jpg");
                return true;
            }

			default:
				return true;
		}
	}

	// do not process hits if an animation is occurring - except for App kills above
	if( playStack::mv_Leg.inUse ) return true;

	// mouse moved
	if( rEvent.Type == sf::Event::MouseMoved )
	{
		mseX = rEvent.MouseMove.X;
		mseY = rEvent.MouseMove.Y;

		if( okBox::open )
        {
            if( p_alert )
                p_alert->mseOver();
            else
                cout << "p_alert == NULL" << endl;

            return true;
        }

        if( !beginHand )
		{
            hand[turn].mseOver();
            deck.mseOver();

            for( plIt = playList[0].begin(); plIt != playList[0].end(); ++plIt )
                if( plIt->mseOver() ) break;

            for( plIt = playList[1].begin(); plIt != playList[1].end(); ++plIt )
                if( plIt->mseOver() ) break;

            if( turnPhase != 3 )// not end of hand
                discardPile.mseOver();
		}

	}// end of mouse moved


	// mouse button pressed
	if( rEvent.Type == sf::Event::MouseButtonPressed )
	{
		if( rEvent.MouseButton.Button == sf::Mouse::Left )
		{
		    if( okBox::open )
            {
                if( p_alert )
                    p_alert->hit();
                else
                    cout << "p_alert == NULL" << endl;

                return true;
            }

            gameHit_dn();

            return true;
		}// end left button down
	}

	// mouse button released
	if( rEvent.Type == sf::Event::MouseButtonReleased )
	{
		if( rEvent.MouseButton.Button == sf::Mouse::Left )
		{
		    if( okBox::open ) return true;

		    if( !beginHand )
		    {
                hand[turn].hitLt_up();

                for( plIt = playList[0].begin(); plIt != playList[0].end(); ++plIt )
                    plIt->hitLt_up();
                for( plIt = playList[1].begin(); plIt != playList[1].end(); ++plIt )
                    plIt->hitLt_up();
		    }

			return true;
		}
	}

	return true;
}// end of handleEvent()

void gameHit_dn(void)
{
    list< playStack >::iterator plIt;// for looping

    if( !beginHand ) hand[turn].hitLt_dn();

    // time to draw
    if( turnPhase == 1 )
    {
        p_dest = &hand[ turn ];

        if( deck.hitLt_dn() )
        {
            p_src = &deck;
            go = true;
        }
        else if( discardPile.hitLt_dn() )
        {
            p_src = &discardPile;
            go = true;
        }
        else// X-code: Allows card rearrangement in the playStacks
        {
            for( plIt = playList[0].begin(); plIt != playList[0].end(); ++plIt )
                if( plIt->hitLt_dn() ) break;
            for( plIt = playList[1].begin(); plIt != playList[1].end(); ++plIt )
                if( plIt->hitLt_dn() ) break;
        }
    }

    // time to play/discard
    if( turnPhase == 2 )
    {
        p_src = p_dest = NULL;// dangerous?

        if( hand[ turn ].cardsSelected )
        {
            if( discardPile.hitLt_dn() )
            {
                if( !discardJudge() ) return;// illegal discard attempt ( > 1 card )

                p_src = &hand[ turn ];
                p_dest = &discardPile;
                go = true;
            }
            else if( !hand[turn].mo )// look for a hit on a playStack
            {
                if( !playJudge() ) return;// illegal play attempt

                bool found = false;
                for( plIt = playList[turn].begin(); plIt != playList[turn].end(); ++plIt )
                {
                    if( plIt->mo )
                    {
                        found = true;
                        break;
                    }
                }

                if( found )// cards will add onto existing playStack
                {
                    p_src = &hand[turn];
                    p_dest = &(*plIt);
                    go = true;
                }
                else// create a new playStack at the mouse location and put the cards there!
                {
                    playList[turn].push_back( playStack( static_cast<float>(mseX), static_cast<float>(mseY) ) );
                    p_dest = &playList[turn].back();
                    p_src = &hand[turn];
                    go = true;
                }
            }
        }
        else// allow playList card rearrange if no cards selected in hand
        {
            for( plIt = playList[0].begin(); plIt != playList[0].end(); ++plIt )
                if( plIt->hitLt_dn() ) break;
            for( plIt = playList[1].begin(); plIt != playList[1].end(); ++plIt )
                if( plIt->hitLt_dn() ) break;
        }
    }// end if turnPhase == 2

    // end of hand
    if( turnPhase == 3 && deck.hitLt_dn() )
    {
        // return all cards to the deck
        hand[0].returnCards( deck );// one of these
        hand[1].returnCards( deck );// is already empty
        discardPile.returnCards( deck );
        for( plIt = playList[0].begin(); plIt != playList[0].end(); ++plIt ) plIt->returnCards( deck );
        for( plIt = playList[1].begin(); plIt != playList[1].end(); ++plIt ) plIt->returnCards( deck );
        playList[0].clear();
        playList[1].clear();
        playStack::stVec.clear();
        playStack::kindVec.clear();

        // reset the frame logic
        turnPhase = 0;
        beginHand = true;
    }

    return;
}// end of gameHit_dn()

bool discardJudge(void)
{
    // attempt to discard more than 1 card
    if( hand[turn].selectedList.size() > 1  )
    {
        okBox::open = true;
        p_alert = &alert1;
        return false;
    }
    return true;// discard OK
}

bool twoCardJudge( vector<card>& Cards )
{
    size_t N = Cards.size();
    vector<char> categ;// stores outcome of isPlay call on each card = 'h', 'L', 'k', 'n'
    vector<size_t> order( N, 0 );// order in which to submit cards to addToStraight

    size_t i=0;// for looping - g=good ones, x= unknown
    for(i=0; i<N; ++i)
        categ.push_back( playStack::isPlay( Cards[i] ) );// cards initially categorized as 'h', 'L', 'k' or 'n'

    size_t x=0, g=0;
    size_t iterNum = 0;
    bool change = false;// did any categ change this iteration?

    do
    {
        change = false;
        ++iterNum;
        for(x=0; x<N; ++x)
        {
            if( categ[x] != 'h' && categ[x] != 'L' )// card x is unknown
            {
                for(g=0; g<N; ++g)// card g is good
                    if( g != x && Cards[x].suit == Cards[g].suit )// skip the self check
                    {
                        if( categ[g] == 'h' )
                            if( (Cards[x].face == Cards[g].face + 1) || ( Cards[g].face==13 && Cards[x].face==1 ) )
                            {
                                categ[x] = 'h';// new high
                                order[x] = iterNum;
                                change = true;
                                break;// look no further
                            }

                        if( categ[g] == 'L' && Cards[x].face == Cards[g].face - 1 )
                        {
                            categ[x] = 'L';// new Low
                            order[x] = iterNum;
                            change = true;
                            break;// look no further
                        }
                    }// suit match
            }
        }
    } while( change && iterNum < N+2 );// N+2 ? should end on change first

    // examine outcome - if any categ still = 'n' then play is bad
    for(i=0; i<N; ++i)
    {
        cout << Cards[i].face << Cards[i].suit << categ[i] << order[i] << "  ";
        if( categ[i] == 'n' ) return false;
    }
    cout << endl;


    // got here? Play is GOOD. Submit cards in order
    iterNum = 0;
    size_t Nsub = 0;
    while( Nsub < N && iterNum < N )
    {
        for(size_t j=0; j<N; ++j)
            if( order[j] == iterNum )
            {
                if( categ[j] == 'k')
                    cout << "played the 4th " << Cards[j].face << endl;
                else if( !playStack::addToStraight( Cards[j] ) )
                    cout << "Problem in twoCardJudge" << endl;

                ++Nsub;
            }
        ++iterNum;
    }

    return true;// play is good
}// end of twoCardJudge()

bool playJudge(void)
{
    size_t Nsel = hand[turn].selectedList.size();
    size_t i=0;// for looping
    vector<card> Cards;// for copy of selected cards
    bool goodPlay = true;// presume that play is good

    if( Nsel > 1 )// fill vector with copies of the cards
        for( i=0; i< Nsel; ++i) Cards.push_back( *hand[turn].selectedList[i] );


    if( Nsel == 1 )// 4-kind or add to straight ok
    {
        // try adding to straight first
        if( playStack::addToStraight( *hand[turn].selectedList[0] ) ) return true;
        // try adding to 3-kind
        int matchFace = hand[turn].selectedList[0]->face;
        for( size_t i = 0; i< playStack::kindVec.size(); ++i )
        {
            if( matchFace == playStack::kindVec[i] )
            {
                cout << "played the 4th " << matchFace << endl;
                return true;
            }
        }
        goodPlay = false;// illegal play
    }
    else if( Nsel == 2 )// add to straight ok
    {
        goodPlay =  twoCardJudge( Cards );
    }
    else// 3 or more cards in play. No plays below are made off of existing plays.
    {
        // check for 3 or 4-kind
        int matchFace = Cards[0].face;
        for( i=1; i< Nsel; ++i)
            if( Cards[i].face != matchFace )
            {
                goodPlay = false;// not 3 or 4-kind
                break;
            }

        if( goodPlay )// add to playStacks list of 3 of a kind played
        {
            playStack::kindVec.push_back( matchFace );
            // testout
            cout << "Added " << matchFace << "'s to kindVec" << endl;
        }


        if( !goodPlay )// its not 3 or 4-kind
        {
            goodPlay = true;// presume the play is OK

            // check if all suits match
            char matchSuit = Cards[0].suit;
            for( i=1; i< Nsel; ++i)
                if( Cards[i].suit != matchSuit ) goodPlay = false;

            // check for straight
            if( goodPlay )// all suits matched
            {
                sort( Cards.begin(), Cards.end() );

                // most cases
                matchFace = Cards[0].face;
                for( i=1; i< Nsel; ++i)
                    if( Cards[i].face != ++matchFace )
                    {
                        goodPlay = false;
                        break;
                    }

                // handle special case: Ace low straight
                if( Cards[0].face == 2 && Cards[1].face == 3 && Cards[Nsel-1].face == 14 )// have { 2, 3,..., Ace }
                {
                    if( isAceLowStraight( Cards, Nsel ) )
                        return true;
                    else
                        goodPlay = false;
                }

                if( goodPlay )// add to playStacks list of straights played
                {
                    playStack::stVec.push_back( playStack::straight( matchSuit, Cards[0].face, Cards[Nsel-1].face ) );
                    // testout
                    cout << "Added ";
                    for( i=0; i< Nsel; ++i) cout << Cards[i].face << " ";
                    cout << matchSuit << " to stVec" << endl;
                }

            }// end check for straight
        }
    }// end if 3 or more cards in play


    // block a bad play
    if( !goodPlay )
    {
        okBox::open = true;
        p_alert = &alert2;
    }

    return goodPlay;// return true if the play is good
}// end of playJudge()

// make this check for matching suits
bool isAceLowStraight(vector<card>& Cards, int N)
{
    bool goodPlay= false;

    if( N > 2 && Cards[0].face == 2 && Cards[1].face == 3 && Cards[N-1].face == 14 )// have { 2, 3,..., Ace }
    {
        goodPlay= true;
        int i=0, matchFace = 3;
        for( i=2; i< N-1; ++i)
            if( Cards[i].face != ++matchFace )
            {
                goodPlay = false;
                break;
            }
        if( goodPlay )
        {
            // find the Ace and demote its face value
            for( i=0; i< N; ++i)
                if( hand[turn].selectedList[i]->face == 14 )
                {
                    hand[turn].selectedList[i]->face = 1;
                    break;
                }
            // add this play to stVec
            playStack::stVec.push_back( playStack::straight( Cards[0].suit, 1, Cards[N-2].face ) );
            // testout
            cout << "Added 1 ";
            for( i=0; i< N-1; ++i) cout << Cards[i].face << " ";
            cout << Cards[0].suit << " to stVec" << endl;
        }
    }
    return goodPlay;
}// end of isAceLowStraight()

bool LoadImages(void)
{
    if( !backImg.LoadFromFile( "images/back-red-75-2.png" ) )
        return false;

    // set static vars for card
    card::w = static_cast<float>( backImg.GetWidth() );
    card::h = static_cast<float>( backImg.GetHeight() );

    deck.spr.SetImage( backImg );
    deck.spr.SetCenter( static_cast<float>( backImg.GetWidth() )/2.0f, static_cast<float>( backImg.GetHeight() )/2.0f );
    deck.spr.SetPosition( deck.x0, deck.y0 );
    deck.mv_spr = deck.spr;

    std::string str_prefix[] = {"images/hearts-", "images/diamonds-", "images/spades-", "images/clubs-"};
    std::string fname;

    for(int s=0; s<4; ++s )
    {
        for(int f=2; f<=14; ++f)
        {
            fname = str_prefix[s];
            switch( f )
            {
                case 14: fname += "a-75.png"; break;
                case 10: fname += "10-75.png"; break;
                case 11: fname += "j-75.png"; break;
                case 12: fname += "q-75.png"; break;
                case 13: fname += "k-75.png"; break;

                default:
                fname += (char)( '0' + f );
                fname += "-75.png";
                break;
            }
   //         cout << fname << endl;
            if( !cardImg[13*s + f-2].LoadFromFile( fname.c_str() ) )
            {
                cout << "Could not load from file: " << fname << endl;
                return false;
            }

            char st = 'H';
            switch( s )
            {
                case 0: st = 'H'; break;
                case 1: st = 'D'; break;
                case 2: st = 'S'; break;
                case 3: st = 'C'; break;
            }
            deck.addCard( card( cardImg[13*s + f-2], st, f ) );
        }
    }

	return true;
}// end of LoadImages()

// overloads above (). Cards are loaded according to list in fname
bool LoadImages( const char* fname_CardList )
{
    std::ifstream fin( fname_CardList );

    if( !fin )
    {
        cout << "Could not load from file: " << fname_CardList << endl;
        return false;// terminate program
    }

    if( !backImg.LoadFromFile( "images/back-red-75-2.png" ) )
        return false;

    // set static vars for card
    card::w = static_cast<float>( backImg.GetWidth() );
    card::h = static_cast<float>( backImg.GetHeight() );

    deck.spr.SetImage( backImg );
    deck.spr.SetCenter( static_cast<float>( backImg.GetWidth() )/2.0f, static_cast<float>( backImg.GetHeight() )/2.0f );
    deck.spr.SetPosition( deck.x0, deck.y0 );
    deck.mv_spr = deck.spr;

    std::string str_prefix[] = {"images/hearts-", "images/diamonds-", "images/spades-", "images/clubs-"};
    std::string fname;

    deck.TEST = true;
    int f=0;
    char st = 'H';// the face and suit read from the file

    while( fin )
    {
        fin >> f >> st;// int char

        int s = 0;// index to suit
        switch( st )
        {
            case 'H': s = 0; break;
            case 'D': s = 1; break;
            case 'S': s = 2; break;
            case 'C': s = 3; break;
        }

        fname = str_prefix[s];
        switch( f )
        {
            case 14: fname += "a-75.png"; break;
            case 10: fname += "10-75.png"; break;
            case 11: fname += "j-75.png"; break;
            case 12: fname += "q-75.png"; break;
            case 13: fname += "k-75.png"; break;

            default:
            fname += (char)( '0' + f );
            fname += "-75.png";
            break;
        }
//         cout << fname << endl;
        if( !cardImg[13*s + f-2].LoadFromFile( fname.c_str() ) )
        {
            cout << "Could not load from file: " << fname << endl;
            return false;
        }

        deck.addCard( card( cardImg[13*s + f-2], st, f ) );

    }// end of while()

	return true;
}// end of LoadImages(const char*)

// utility functions
template<class T>
float to_sf_string(sf::String& strArg, T x)// returns position of end of strArg
{
    std::stringstream ss;
    ss << x;
    std::string tempStr;
    ss >> tempStr;
    strArg.SetText( tempStr.c_str() );
    return strArg.GetRect().Right;
}

// functions for computers play. Comp. uses hand[0].
bool c_drawCards(void)
{
    if( c_findPlay( &discardPile ) )
    {
        // find max index value
        int maxIdx = idxVec[0];
        for( vector<int>::iterator it = idxVec.begin() + 1; it != idxVec.end(); ++it )
            if( maxIdx < *it ) maxIdx = *it;
        // compare to # of cards in hand
        if( maxIdx >= hand[0].Ncards )// then the play involves cards from the discard pile
        {
            discardPile.NcardsToSend = 1 + maxIdx - hand[0].Ncards;
            p_src = &discardPile;
            p_dest = &hand[0];
            return true;
        }
    }

    // otherwise, draw from the deck
    p_src = &deck;
    p_dest = &hand[0];

    return true;// assigned to go
}

bool c_discard(void)
{
    if( hand[0].Ncards > 0 )
    {
        hand[0].cardsSelected = true;
//        hand[0].selectedList.push_back( hand[0].cards.begin() );// always discarding 1st card in hand (for now)
        hand[0].selectedList.push_back( c_findLoRankCard() );
        p_src = &hand[0];
        p_dest = &discardPile;
        return true;
    }
    return false;// assigned to go
}

list<card>::iterator c_findLoRankCard(void)
{
    // create space to store the card ranks
    int N = hand[0].Ncards;
    vector<int> rank(N,0);

    // copy the card suit and face values to a vector
    vector<sf_pair> handVec;
    list<card>::iterator cit = hand[0].cards.begin();
    for( ; cit != hand[0].cards.end(); ++cit )
        handVec.push_back( sf_pair( cit->suit, cit->face ) );

    int i=0, j=0;// for looping

    // compare cards in hand to each other
    for( i=0; i<N-1; ++i)
        for( j=i+1; j<N; ++j)
        {
            //              pair found               &&      less than 2 are already in play
            if( (handVec[i].face == handVec[j].face) && (playStack::faceCnt[ handVec[i].face-2 ] < 2) )
            { rank[i] += 8; rank[j] +=8; }// keep pairs
            else if(handVec[i].suit == handVec[j].suit)// suits match
            {
                if( (handVec[i].face == handVec[j].face+1) || (handVec[i].face == handVec[j].face-1) )// keep short straight
                { rank[i] += 2; rank[j] +=2; }
                else if( (handVec[i].face == handVec[j].face+2) || (handVec[i].face == handVec[j].face-2) )// keep short straight
                { rank[i] += 2; rank[j] +=2; }
            }
        }

    // try to not make pairs in the discardPile
    cit = discardPile.cards.begin();
    for( i=0; i<N; ++i)
        for( cit = discardPile.cards.begin(); cit != discardPile.cards.end(); ++cit)
            if( handVec[i].face == cit->face ) rank[i] += 3;

    // TEST OUT
    for( i=0; i<13; ++i) cout << playStack::faceCnt[i] << " ";
    cout << endl;

    // find index to card with lowest rank
    int loRankIdx = 0;
    for( i=0; i<N; ++i)// sb 1 to N
    {
        cout << rank[i] << " ";
        if( rank[i] < rank[loRankIdx] ) loRankIdx = i;
    }
    cout << endl;

    // find iterator to this card
    cit = hand[0].cards.begin();
    for( i=0; i<loRankIdx; ++i) ++cit;

    return cit;
}// end of c_discardJudge()

bool c_findPlay( const discardStack* p_ds )
{
    // idxVec was filled when c_drawCards() was called. Use this play unless drew from deck.
//    if( !idxVec.empty() && p_src == &discardPile ) return true;

    bool play_found = false;

    // make a copy of hand[0].cards to a vector
    vector<sf_pair> handVec;
    list<card>::iterator cit = hand[0].cards.begin();
    for( ; cit != hand[0].cards.end(); ++cit )
        handVec.push_back( sf_pair( cit->suit, cit->face ) );

    if( p_ds )// consider the cards in the discardPile as part of the hand
    {
        list<card>::const_reverse_iterator c_rit = p_ds->cards.rbegin();
        for( ; c_rit != p_ds->cards.rend(); ++c_rit )
            handVec.push_back( sf_pair( c_rit->suit, c_rit->face ) );
    }

    // find 3-kind
    play_found = c_find_3kind( handVec );// something is fucked up here!

    // find a 3 card straight
    if( !play_found )
        play_found = c_find_3straight( handVec );

    // extend an existing play
    if( !play_found )
        play_found = c_find_addToExist( handVec );

    if( play_found )// save the iterators to the cards in citVec
        return true;// straight play found!

    return false;// no play found. Proceed to discard
}// end of c_findPlay()

int c_scorePlay( vector<sf_pair>& handVec )
{
    int score = 0;

    for(size_t i=0; i<idxVec.size(); ++i)
    {
        int fv = handVec[ idxVec[i] ].face;
        if( fv == 14 )// high ace
            score += 15;
        else if( fv >= 10 )
            score += 10;
        else
            score += 5;
    }
    return score;
}

bool c_find_addToExist( vector<sf_pair>& handVec )
{
    size_t i=0, j=0;// for looping
    size_t N = handVec.size();
    if( N < 2 ) return false;
    idxVec.clear();

    // 4th of 3 kind
    for( i=0; i< playStack::kindVec.size(); ++i)
        for( j=0; j<N; ++j )
            if( handVec[j].face == playStack::kindVec[i] )
            {
                idxVec.push_back(j);
                return true;
            }

    // extend a straight on the high side
    for( i=0; i< playStack::stVec.size(); ++i)
        for( j=0; j<N; ++j )
            if( (handVec[j].suit == playStack::stVec[i].suit) && (handVec[j].face == playStack::stVec[i].hi + 1) )
            {
                idxVec.push_back(j);
                return true;
            }

    // extend a straight on the low side
    for( i=0; i< playStack::stVec.size(); ++i)
        for( j=0; j<N; ++j )
        {
            int fc = handVec[j].face;
            if( fc == 14 ) fc = 1;
            if( (handVec[j].suit == playStack::stVec[i].suit) && (fc == playStack::stVec[i].lo - 1) )
            {
                idxVec.push_back(j);
                handVec[j].face = fc;
                return true;
            }
        }


    return false;
}// end of c_find_addToExist()

bool c_find_3kind( vector<sf_pair>& handVec )
{
    int N = handVec.size();
    if( N < 4 ) return false;// not enough cards for a 3 card play
    idxVec.clear();
    idxVec.reserve(3);

    // find 3 of a kind
    int cnt = 0;
    int i=0, k=0;// for looping and index storage
    bool k3_found = false;
    int matchFace = 0;

    for( i=0; i<N-2; ++i)
    {
        matchFace = handVec[i].face;
        cnt = 1;
        idxVec.push_back(i);
        for( k=i+1; k<N; ++k )
        {
            if( handVec[k].face == matchFace )
            {
                idxVec.push_back(k);// all other indexes
                ++cnt;
                if( cnt == 3 )
                {
                    k3_found = true;
                    break;// done searching
                }
            }
        }
        if( k3_found )
            break;
        else
            idxVec.clear();
    }

    if( k3_found )
    {
        cout << "3-" << matchFace << "'s found: " << idxVec[0] << " " << idxVec[1] << " " << idxVec[2] << endl;
        return true;// play found!
    }

    return false;
}// end of c_find3kind()

struct fi_pair// store face value, index pair. Used in c_find_3Straight
{
    int face;
    int idx;
    bool operator<(const fi_pair& b) const { return face < b.face; }
};

// works - and will find an Ace low straight
bool c_find_3straight( vector<sf_pair>& handVec )
{
    int N = handVec.size();
    if( N < 4 ) return false;// not enough cards for a 3 card play
    idxVec.clear();
    vector<fi_pair> fc(N);// list of face values and indexes found in a given suit
    int cnt = 0;// count of cards found in suit i
    int stLen = 0;// length of straight found
    bool stFound = false;
    int i=0, k=0;// for looping
    char matchSuit[] = { 'H', 'D', 'C', 'S' };

    for( i=0; i<4; ++i)// for each suit
    {
        cnt = 0;
        for( k=0; k<N; ++k )
        {
            if( handVec[k].suit == matchSuit[i] )
            {
                fc[cnt].face = handVec[k].face;// build a list of face values found
                fc[cnt++].idx = k;
            }
        }
        if( cnt >= 3 )// see if there is a straight in suit i
        {
            // search for sequence in fc[]
            sort( fc.begin(), fc.begin() + cnt );// sort in ascending order
            // SPECIAL CASE: Ace low straight
            if( fc[1].face == 3 && fc[cnt-1].face == 14 && fc[cnt-3].face != 12 )// found { 2, 3,..., Ace }
            {
                stFound = true;
                stLen = 3;
                handVec[ fc[cnt-1].idx ].face = 1;// demote the Ace in handVec to face = 1
                idxVec.push_back( fc[cnt-1].idx ); idxVec.push_back( fc[0].idx ); idxVec.push_back( fc[1].idx );
            }
            else// all other cases
            {
                for( k=cnt-1; k>=2; --k )// find the high straight. Minimum straight length = 3
                {
                    stLen = 1;
                    while( (stLen < N-1) && (k-stLen >= 0) && (fc[k-stLen+1].face == fc[k-stLen].face + 1)  )// eg. {J, Q, K, A}
                        if( ++stLen == 3 ) stFound = true; // minimum length reached

                    if( stFound )
                    {
                        for( int j=k-stLen+1; j<=k; ++j)
                            idxVec.push_back( fc[j].idx );
                        break;
                    }
                }
            }
        }
        if( stFound ) break;
    }// end for each suit

    if( stFound )
    {
        cout << "straight found:" << handVec[ idxVec[0] ].face << handVec[ idxVec[0] ].suit << " " << handVec[ idxVec[1] ].face << handVec[ idxVec[1] ].suit << " " << handVec[ idxVec[2] ].face << handVec[ idxVec[2] ].suit << endl;
        return true;// play found!
    }

    return false;
}// end of c_find_3straight()

bool c_makePlay(void)
{
    size_t i = 0;// for looping

    hand[0].cardsSelected = true;
    hand[0].selectedList.clear();
    list<card>::iterator cit;

    for(i=0; i<idxVec.size(); ++i)
    {
        cit = hand[0].cards.begin();
        for(int j=0; j<idxVec[i]; ++j) ++cit;
        {
            hand[0].selectedList.push_back( cit );
//              cout << "citVec += " << cit->face << " " << cit->suit << endl;
        }
    }
    int N = hand[0].selectedList.size();

    // update the play list
    if( hand[0].selectedList.size() > 2 )
    {
        if( hand[0].selectedList[0]->face == hand[0].selectedList[1]->face )// it's 3k
        {
            playStack::kindVec.push_back( hand[0].selectedList[0]->face );
            cout << "Added " << hand[0].selectedList[0]->face << "'s to kindVec" << endl;
        }
        else// it's a straight
        {
            // special case - Ace low straight
            if( hand[0].selectedList[0]->face == 14 )
                hand[0].selectedList[0]->face = 1;

            playStack::stVec.push_back( playStack::straight(hand[0].selectedList[0]->suit, hand[0].selectedList[0]->face, hand[0].selectedList[N-1]->face) );
            cout << "Added ";
            for( i=0; i< 3; ++i) cout << hand[0].selectedList[i]->face << " ";
            cout << hand[0].selectedList[0]->suit << " to stVec" << endl;
        }
    }
    else if( hand[0].selectedList.size() == 1 )
    {
        if( !playStack::addToStraight( *(hand[0].selectedList[0]) ) )
            cout << "Added 4th " << hand[0].selectedList[0]->face << " to 3-kind." << endl;
    }

    idxVec.clear();

    // trigger the play
    playList[0].push_back( playStack( c_psX, c_psY ) );
    p_dest = &playList[0].back();
    p_src = &hand[0];

    // increment next playStack position
    c_psX += c_dpsX;
    if( c_psX > 700.0f )
    {
        c_psY += c_dpsY;
        c_psX = 500.0f;
    }

    c_playFound = false;
    return true;

}// end of c_makePlay()

/*
// functions BK
*/
