#include "okBox.h"

bool okBox::open = false;

okBox::okBox(float PosX, float PosY, const sf::Unicode::Text Msg): posX(PosX), posY(PosY)
{
    msg.SetText( Msg );
    msg.SetPosition( posX + 20.0f, posY + 20.0f );
    msg.SetFont( sf::Font::GetDefaultFont() );
    msg.SetColor( sf::Color(0,0,0) );
    msg.SetSize( 14.0 );

    szX = msg.GetRect().Right + 20.0f - posX;
    szY = msg.GetRect().Bottom + 70.0f - posY;

    okButt.type = 's';
    okButt.szX = 40;
    okButt.szY = 30;
    okButt.posX = posX + szX/2.0f - 20.0f;
    okButt.posY = posY + szY - 50.0f;
    okButt.INITlabel( "OK", 16, sf::Color(0,0,0), 'c' );
}

okBox::~okBox()
{
    //dtor
}

void okBox::draw(void)
{
    if( open )
    {
        sf::Shape BKrect = sf::Shape::Rectangle(posX, posY, posX+szX, posY+szY, sf::Color(255,255,255), 3.0f, sf::Color(0,0,255) );
        okButt.pWndw->Draw( BKrect );
        okButt.pWndw->Draw( msg );
        okButt.draw();
    }
    return;
}

bool okBox::hit(void)
{
    if( open && okButt.hit() )
    {
        open = false;
        okButt.sel = okButt.mo = false;
        return true;
    }
    return false;
}

bool okBox::mseOver(void)
{
    return okButt.mseOver();
}
