#include "playStack.h"

// static members
vector<playStack::straight> playStack::stVec;// list of straights in play
vector<int> playStack::kindVec;// list of 3 and 4 of a kind plays made
int playStack::faceCnt[13] = {0};

playStack::playStack(float X0, float Y0): cardStack( X0, Y0 )
{
    held = false;
    grabIdx = releaseIdx = 0;
}

playStack::~playStack()
{
    //dtor
}

void playStack::draw(void)
{
    for( std::list<card>::iterator it = cards.begin(); it != cards.end(); ++it )
    {
		    it->draw();
    }

    if( mo )
    {
        float xLt = x0 - card::w/2.0f + dx*(float)currIdx + 0.5f*dx;
        sf::Shape Line = sf::Shape::Line( xLt, y0-card::h/2.0f, xLt, y0+card::h/2.0f, 3.0f, sf::Color(128,128,128,128) );
        card::pWndw->Draw( Line );
    }

    if( held )
    {
        float xLt = x0 - card::w/2.0f + dx*(float)grabIdx + 0.5f*dx;
        sf::Shape Line = sf::Shape::Line( xLt, y0-card::h/2.0f, xLt, y0+card::h/2.0f, 3.0f, sf::Color(0,255,0,128) );
        card::pWndw->Draw( Line );
    }
}

bool playStack::mseOver(void)
{
    float f_mseY = static_cast<float>( r_mseY );
    mo = false;

    if( f_mseY < y0 - card::h/2.0f )// mse is above the stack
    {
        held = false;
        return false;
    }
    if( f_mseY > y0 + card::h/2.0f )// mse is below the stack
    {
        held = false;
        return false;
    }

    float xLt = x0 - card::w/2.0f;
    if( held ) xLt -= dx;
    float xRt = xf + card::w/2.0f;
    float f_mseX = static_cast<float>( r_mseX );

    if( f_mseX < xLt )// mse is left of the stack
    {
        held = false;
        return false;
    }
    if( f_mseX > xRt )// mse is right of the stack
    {
        held = false;
        return false;
    }

    currIdx = static_cast<int>( (dx + f_mseX - x0 + card::w/2.0f)/dx ) - 1;
    if( currIdx > Ncards - 1 ) currIdx = Ncards - 1;
    mo = true;

    return true;
}// end of mseOver()

bool playStack::hitLt_dn(void)
{
    if( mo )
    {
        held = true;
        grabIdx = currIdx;
        std::cout << "grabIdx = " << grabIdx << std::endl;
    }
    return mo;
}

void playStack::hitLt_up(void)
{
    held = false;

    if( mo )
    {
        releaseIdx = currIdx;
        std::cout << "releaseIdx = " << releaseIdx << std::endl;

        if( releaseIdx != grabIdx )// just rearraning cards in hand
            moveCardInHand();
    }
}// end of hitLt_up()

void playStack::moveCardInHand(void)
{
    bool repos = false;
    int i = 0;// for looping

    // move card within stack
    std::list<card>::iterator insertIt = cards.begin();
    for( i=0; i<=releaseIdx; ++i) ++insertIt;

    std::list<card>::iterator deleteIt = cards.begin();
    for( i=0; i<grabIdx; ++i) ++deleteIt;

    card mv_card = *deleteIt;

    if( releaseIdx < grabIdx - 1 )// move left
    {
        repos = true;
        cards.erase( deleteIt );
        cards.insert( insertIt, mv_card );
    }

    if( releaseIdx > grabIdx )// move right
    {
        repos = true;
        cards.insert( insertIt, mv_card );
        cards.erase( deleteIt );
    }

    // reassign card positions
    if( repos )
        regroupCards();
}

void playStack::regroupCards(void)
{
    float x = x0;
    std::list<card>::iterator it = cards.begin();
    for( ; it != cards.end(); ++it )
    {
        it->spr.SetPosition( x, y0 );
        x += dx;
    }
    xf = x;
}

card playStack::removeCard(void)
{
    card card_out = cards.back();
    cards.pop_back();
    --Ncards;
    xf -= dx;
    return card_out;
}

void playStack::addCard( card newCard )
{
    newCard.spr.SetPosition( xf, y0 );
    cards.push_back( newCard );
    xf += dx;
    ++Ncards;
    if( newCard.face == 1 )
        ++faceCnt[12];
    else
        ++faceCnt[ newCard.face - 2 ];
}

// sends all cards at once
bool playStack::sendCard(cardStack& r_dest)
{
    if( !mv_Leg.inUse )// start next card deal
    {
        mv_card = removeCard();
        mv_Leg.pSprite = &mv_card.spr;
        mv_Leg.tLeg = 0.0f;
        mv_Leg.inUse = true;
        mv_Leg.INIT( mv_card.spr.GetPosition().x, mv_card.spr.GetPosition().y, r_dest.xf, r_dest.y0, mv_speed );
    }

    // move the card
    mv_Leg.move();

    if( !mv_Leg.inUse )// end this card deal
    {
        r_dest.addCard( mv_card );
        regroupCards();

        if( cards.empty() )
            return false;
        else
            return true;
    }
    return true;// dealLeg still inUse !
}

// this function only checks if a card can be played. It does not modify stVec or kindVec.
char playStack::isPlay( card& c )
{
    size_t i = 0;// for looping

    // search for play to a straight first
    for( i = 0; i< stVec.size(); ++i )
    {
        if( c.suit == stVec[i].suit )
        {
            if( c.face == stVec[i].lo - 1 )// c can be played to low end of this straight
                return 'L';
            if( c.face == stVec[i].hi + 1 )// c can be played to high end of this straight
                return 'h';
            // cover special case: Ace after King
            if( c.face == 1 && stVec[i].hi == 13 )
                return 'h';
        }
    }

    // search for a play to 3 of a kind
    for( i = 0; i< kindVec.size(); ++i )
        if( c.face == kindVec[i] ) return 'k';

    return 'n';
}// end of isPlay()

bool playStack::addToStraight( card& c )
{
    size_t i = 0;// for looping

    // search for play to a straight first
    for( i = 0; i< stVec.size(); ++i )
    {
        if( c.suit == stVec[i].suit )
        {
            if( c.face == stVec[i].lo - 1 )// c can be played to low end of this straight
            {
                stVec[i].lo -= 1;
                cout << "Added to st. Now: " << stVec[i].suit << " " << stVec[i].lo << " to " << stVec[i].hi << endl;
                return true;
            }
            if( c.face == stVec[i].hi + 1 )// c can be played to high end of this straight
            {
                stVec[i].hi += 1;
                cout << "Added to st. Now: " << stVec[i].suit << " " << stVec[i].lo << " to " << stVec[i].hi << endl;
                return true;
            }
            // cover special case: Ace before 2
            if( c.face == 14 && stVec[i].lo == 2 )
            {
                stVec[i].lo -= 1;
                c.face = 1;
                cout << "Added to st. Now: " << stVec[i].suit << " " << stVec[i].lo << " to " << stVec[i].hi << endl;
                return true;
            }
        }
    }
    return false;
}// end of addToStraight()
