#ifndef PLAYSTACK_H
#define PLAYSTACK_H

#include "cardStack.h"


class playStack : public cardStack
{
    public:

    struct straight
    {
        char suit;
        int lo;
        int hi;
        straight(char Suit, int Lo, int Hi): suit(Suit), lo(Lo), hi(Hi) {}
    };

    static vector<straight> stVec;// list of straights in play
    static vector<int> kindVec;// list of 3 and 4 of a kind plays made
    static int faceCnt[13];

    bool held;
    int currIdx;// maintained by mseOver()
    int grabIdx;// = currIdx when held = true in hitLt_dn()
    int releaseIdx;// = currIdx when held = false in hitLt_up()

    // functions


    static char isPlay( card& c );// returns 'n' if c can't be played. Returns 'k'=kind, 'l'=lo, 'h'=hi if it can be.
    static bool addToStraight( card& c );// adds c to an existing straight play. Returns true if it can be added.

    virtual void draw(void);
    virtual bool mseOver(void);
    virtual bool hitLt_dn(void);
    card removeCard(void);
    virtual bool sendCard(cardStack& r_dest);

    void hitLt_up(void);
    void moveCardInHand(void);// helper for hitLt_up()
    void regroupCards(void);
    void addCard( card newCard );// override base version

    playStack(float X0, float Y0);
    ~playStack();
};

#endif // PLAYSTACK_H
