#include <iostream>
#include <windows.h>
#include <tlhelp32.h>
#include "remote_addr.h"
using namespace std;



HANDLE GetProcessHandle(const char *process_name, DWORD dwAccess);
HINSTANCE LoadLibraryIntoProcess(HANDLE hProcess, const char *libname);

char *process_name=NULL;
char *procedure_name="remote_thread@4";
char *module_name="testdll.dll";



int main(int argc, char *argv[])
{
  if(argc<4)
    {
      cout <<"Usage: "<<argv[0]<<" process_name dll_name dll_function"<<endl;
      cout <<"Example: "<<argv[0]<<" test.exe my_dll.dll say_hi@4"<<endl;
      cout <<endl;
      return 0;
    }

  process_name=argv[1];
  module_name=argv[2];
  procedure_name=argv[3];

  //
  // Step 1: Get handle of the process to which we will innject the DLL
  //
  unsigned flags=PROCESS_QUERY_INFORMATION  | PROCESS_CREATE_THREAD | PROCESS_VM_OPERATION | PROCESS_VM_READ | PROCESS_VM_WRITE;
  HANDLE hProcess=GetProcessHandle(process_name,flags);

  if(hProcess==0 || hProcess==INVALID_HANDLE_VALUE)
    {
      cout <<"Could not get process handle"<<endl;
      return 1;
    }

  //
  // Step 2: Load DLL into process
  //
  HINSTANCE hi=LoadLibraryIntoProcess(hProcess,module_name);
  if(hi==NULL)
    {
      cout <<"Could not load DLL into process"<<endl;
      return GetLastError();
    }


  //
  // Step 5: Get address of the remote function
  //
  FARPROC fp;
  fp=GetRemoteProcAddress(hProcess,(HMODULE)hi, procedure_name,0,false);
  if(fp==NULL)
    {
      cout <<"Remote procedure not found"<<endl;
      return GetLastError();
    }
  //
  // Step 6: Use CreateRemoteThread to call a function from the loaded DLL
  //
  if(CreateRemoteThread(hProcess,0,0,(LPTHREAD_START_ROUTINE)fp,0,0,0)==0)
    {
      cout <<"Failed to create a remote thread. GetLastError() returned "<<GetLastError()<<endl;
      return 6;
    }

  CloseHandle(hProcess);

  return EXIT_SUCCESS;
}





HINSTANCE LoadLibraryIntoProcess(HANDLE hProcess, const char *libname)
{
  // allocate memory in specified process
  void *alloc_addr=VirtualAllocEx(hProcess,0,4096,MEM_COMMIT,PAGE_READWRITE);
  if(alloc_addr==0)
    {
      cout <<"Failed to allocate memory in specified process. GetLastError() "<<GetLastError()<<endl;
      return 0;
    }

  // Copy DLL name to the allocated memory
  if(!WriteProcessMemory(hProcess,alloc_addr,libname,strlen(libname)+1,0))
    {
      cout <<"WriteProcesMemory() error. GetLastError() "<<GetLastError()<<endl;
      return 0;
    }

  HMODULE hKernel32 = GetModuleHandle("Kernel32");

  //
  // Load library into process
  //
  HANDLE hThread = CreateRemoteThread( hProcess,0,0,
                                       (LPTHREAD_START_ROUTINE)GetProcAddress(hKernel32,"LoadLibraryA"),
                                       alloc_addr, 0, NULL );

  WaitForSingleObject( hThread, INFINITE );

  DWORD dwRemoteLib=0;
  GetExitCodeThread( hThread, &dwRemoteLib );

  return (HINSTANCE)dwRemoteLib;

}




HANDLE GetProcessHandle(const char *process_name, DWORD dwAccess)
{
  HANDLE hProcessSnap;
  HANDLE hProcess;
  PROCESSENTRY32 pe32;


  hProcessSnap=CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);

  if(hProcessSnap==INVALID_HANDLE_VALUE)
    {
      cerr <<"Failed to create process snapshot!";
      return INVALID_HANDLE_VALUE;
    }

  pe32.dwSize=sizeof(PROCESSENTRY32);

  if(!Process32First(hProcessSnap,&pe32))
    {
      cerr <<"Process32First() failed\n";
      return INVALID_HANDLE_VALUE;
    }

  do
    {
      if(strcmp(pe32.szExeFile,process_name)==0)
        return OpenProcess(dwAccess,0,pe32.th32ProcessID);

    }
  while(Process32Next(hProcessSnap,&pe32));

}

