/*
// Error.hpp
//
// AUTHORS:     Julius Pettersson
// CREDITS:     n/a
// LCHANGE:     21 01 12 21:43
// PURPOSE:     error reporting and logging
// LICENSE:     Expat/MIT License, see `copying.txt'
//
*/

#ifndef ERROR_HPP__INCLUDED
#define ERROR_HPP__INCLUDED

// standard headers
#include <string>

// automated function call
#define ERROR_LOG(fmt, ...)     error::log(__FILE__, __LINE__, fmt, __VA_ARGS__)

namespace error {

// function prototypes
void log(const char *ppFile, int ppLine, const std::string &what, const std::string &why, ...);

} /* namespace error */

#endif /* ERROR_HPP__INCLUDED */
