#include <windows.h>
#include <winioctl.h>
#include <stdint.h>
#include <iostream>
#include <iomanip>
#include <sstream>
using namespace std;


#define KB                1024ULL // bytes in Kilobyte
#define MB             1048576ULL // bytes in Megabyte
#define GB          1073741824ULL // ...
#define TB       1099511627776ULL
#define PB    1125899906842624ULL


//
// Get disk size using IOCTL_DISK_GET_LENGTH_INFO
//
uint64_t GetDiskLengthIoctl(const char *dsk);
string size_str(uint64_t num_of_bytes);


int main(int argc,char *argv[])
{
  if(argc<2)
    {
      cout <<"Command line usage: "<<argv[0]<<" disk"<<endl<<endl;
      cout <<" disk - partition ( X: ) or disk ( PhysicalDriveX )"<<endl;
      cout <<" eg. "<<argv[0]<<" PhysicalDrive0 "<<endl;
      cout <<" eg. "<<argv[0]<<" C: "<<endl;
      cout <<endl;

      string disk;
      cout <<"Enter name of disk or partition letter. Eg. PhysicalDrive0 or C:\n";
      cin  >>disk;

      disk=string("\\\\.\\")+disk;

      uint64_t size=GetDiskLengthIoctl(disk.c_str());

      cout <<"\nDisk (partition) size is: "<<size_str(size)<<" or "<<size<<" bytes"<<endl;;
    }
  else
    {
      string disk=string("\\\\.\\")+argv[1];

      uint64_t size=GetDiskLengthIoctl(disk.c_str());

      cout <<"\nDisk (partition) size is: "<<size_str(size)<<" or "<<size<<" bytes"<<endl;;
    }
  return 0;
}


uint64_t GetDiskLengthIoctl(const char *dsk)
{
  HANDLE hDisk=CreateFile(dsk,GENERIC_READ,FILE_SHARE_VALID_FLAGS,0,OPEN_EXISTING,0,0);
  if(hDisk==INVALID_HANDLE_VALUE)
    {
      cerr<<"Could not open the disk. GetLastError() returned "<<GetLastError()<<endl;
      return 0;
    }
  GET_LENGTH_INFORMATION gli;
  DWORD ret;

  DeviceIoControl(hDisk,IOCTL_DISK_GET_LENGTH_INFO,0,0,&gli,sizeof(gli),&ret,0);

  CloseHandle(hDisk);
  return gli.Length.QuadPart;
}



string size_str(uint64_t num_of_bytes)
{
  string suffix;
  uint64_t div=0;
  stringstream tmp;

  if(num_of_bytes>PB)
    {
      suffix=" Petabytes";
      div=PB;
    }
  else if(num_of_bytes>TB)
    {
      suffix=" Terabytes";
      div=TB;
    }
  else if(num_of_bytes>GB)
    {
      suffix=" Gigabytes";
      div=GB;
    }
  else if(num_of_bytes>MB)
    {
      suffix=" Megabytes";
      div=MB;
    }
  else if(num_of_bytes>KB)
    {
      suffix=" Kilobytes";
      div=KB;
    }
  else
    {
      tmp <<num_of_bytes<<" bytes";
      return tmp.str();
    }

  tmp<<setprecision(4)<<((long double)num_of_bytes/div)<<suffix;
  return tmp.str();
}
