#include <iostream>
#include <windows.h>
#include <ddk/ntapi.h>
using namespace std;

// Function pointer of NtQuerySystemInformation
typedef NTSTATUS (NTAPI *FP_NTQUERYSYSTEMINFORMATION)(
      SYSTEM_INFORMATION_CLASS SystemInformationClass,
      PVOID SystemInformation,
      ULONG SystemInformationLength,
      PULONG ReturnLength
);

int main()
{
  // NtQuerySystemInformation resides in ntdll.dll
  HINSTANCE hNtDll=GetModuleHandle("ntdll.dll");
  if(hNtDll==0)
    {
      cout <<"ntdll.dll error"<<endl;
      return 1;
    }

  // Initialise function pointer
  FP_NTQUERYSYSTEMINFORMATION NtQuerySystemInformation=
      (FP_NTQUERYSYSTEMINFORMATION)GetProcAddress(hNtDll, "NtQuerySystemInformation");

  if(NtQuerySystemInformation==0)
    {
      cout <<"Could not get address of NtQuerySystemInformation"<<endl;
      return 1;
    }


  SYSTEM_BASIC_INFORMATION sbi; // System information structure
  ULONG bytes_returned,
                   ret;         // function return value

  ret=NtQuerySystemInformation(SystemBasicInformation, &sbi, sizeof(sbi), &bytes_returned);

  if(ret!=STATUS_SUCCESS)
    {
      cout <<"NtQuerySystemInformation error ("<<ret<<")"<<endl;
      return ret;
    }
  cout <<"SystemBasicInformation:"<<endl;
  cout <<"-----------------------------------------"<<endl;

  cout <<"Unknown ???                  "<<sbi.Unknown<<endl;
  cout <<"MaximumIncrement ???         "<<sbi.MaximumIncrement<<endl;
  cout <<"Physical page size           "<<sbi.PhysicalPageSize<<" bytes"<<endl;
  cout <<"Number of physical pages     "<<sbi.NumberOfPhysicalPages<<endl;
  cout <<"Lowest physical page         "<<sbi.LowestPhysicalPage<<endl;
  cout <<"Highest physical page        "<<sbi.HighestPhysicalPage<<endl;
  cout <<"Allocation granularity       "<<sbi.AllocationGranularity<<" bytes "<<endl;
  cout <<"Lowest user address          "<<sbi.LowestUserAddress<<endl;
  cout <<"Highest user address         "<<sbi.HighestUserAddress<<endl;
  cout <<"ActiveProcessors ???         "<<sbi.ActiveProcessors<<endl;
  cout <<"Total number of processors   "<<(int)sbi.NumberProcessors<<endl;

  return 0;
}

