#include <iostream>
#include <windows.h>
#include <ddk/ntapi.h>
using namespace std;

// Function pointer of NtQuerySystemInformation
typedef NTSTATUS (NTAPI *FP_NTQUERYSYSTEMINFORMATION)(
      SYSTEM_INFORMATION_CLASS SystemInformationClass,
      PVOID SystemInformation,
      ULONG SystemInformationLength,
      PULONG ReturnLength
);

int main()
{
  // NtQuerySystemInformation resides in ntdll.dll
  HINSTANCE hNtDll=GetModuleHandle("ntdll.dll");
  if(hNtDll==0)
    {
      cout <<"ntdll.dll error"<<endl;
      return 1;
    }

  // Initialise function pointer
  FP_NTQUERYSYSTEMINFORMATION NtQuerySystemInformation=
      (FP_NTQUERYSYSTEMINFORMATION)GetProcAddress(hNtDll, "NtQuerySystemInformation");

  if(NtQuerySystemInformation==0)
    {
      cout <<"Could not get address of NtQuerySystemInformation"<<endl;
      return 1;
    }


  SYSTEM_CONFIGURATION_INFORMATION sci;
  ULONG bytes_returned,
                   ret;

  ret=NtQuerySystemInformation(SystemConfigurationInformation, &sci, sizeof(sci), &bytes_returned);

  if(ret!=STATUS_SUCCESS)
    {
      cout <<"NtQuerySystemInformation error ("<<ret<<")"<<endl;
      return ret;
    }

  cout <<"SystemConfigurationInformation"<<endl;
  cout <<"-----------------------------------------"<<endl;

  cout <<"Number of disks                "<<sci.DiskCount<<endl;
  cout <<"Number of optical drives       "<<sci.CdRomCount<<endl;
  cout <<"Number of floppy disks         "<<sci.FloppyCount<<endl;
  cout <<"Number of tape drives          "<<sci.TapeCount<<endl;
  cout <<"Number of serial ports         "<<sci.SerialCount<<endl;
  cout <<"Number of parallel ports       "<<sci.ParallelCount<<endl;

  return 0;
}

