//
// Code tested on gcc-mingw 4.5.2
//

#include <iostream>
#include <windows.h>
#include <stdio.h>
#include <ddk/ntapi.h>
#include <iomanip>
using namespace std;


#pragma pack(1)

//
// These strucures are not declared in mingw-gcc
// You can find definitions of these structures in msdn but these two have less 'reserved' fileds
//
// Source: http://undocumented.ntinternals.net/UserMode/Undocumented%20Functions/System%20Information/Structures/SYSTEM_PROCESS_INFORMATION.html
typedef struct _SYSTEM_THREAD {

  LARGE_INTEGER           KernelTime;
  LARGE_INTEGER           UserTime;
  LARGE_INTEGER           CreateTime;
  ULONG                   WaitTime;
  PVOID                   StartAddress;
  CLIENT_ID               ClientId;
  KPRIORITY               Priority;
  LONG                    BasePriority;
  ULONG                   ContextSwitchCount;
  ULONG                   State;
  KWAIT_REASON            WaitReason;
} SYSTEM_THREAD, *PSYSTEM_THREAD;


typedef struct _SYSTEM_PROCESS_INFORMATION {
  ULONG                   NextEntryOffset;
  ULONG                   NumberOfThreads;
  LARGE_INTEGER           Reserved[3];
  LARGE_INTEGER           CreateTime;
  LARGE_INTEGER           UserTime;
  LARGE_INTEGER           KernelTime;
  UNICODE_STRING          ImageName;
  KPRIORITY               BasePriority;
  HANDLE                  ProcessId;
  HANDLE                  InheritedFromProcessId;
  ULONG                   HandleCount;
  ULONG                   Reserved2[2];
  ULONG                   PrivatePageCount;
  VM_COUNTERS             VirtualMemoryCounters;
  IO_COUNTERS             IoCounters;
  SYSTEM_THREAD           Threads[0];


} SYSTEM_PROCESS_INFORMATION, *PSYSTEM_PROCESS_INFORMATION;
#pragma pack(0)

// Function pointer of NtQuerySystemInformation
typedef NTSTATUS (NTAPI *FP_NTQUERYSYSTEMINFORMATION)(
      SYSTEM_INFORMATION_CLASS SystemInformationClass,
      PVOID SystemInformation,
      ULONG SystemInformationLength,
      PULONG ReturnLength
);


void PrintUnicodeString(UNICODE_STRING *str)
{
  for(int i=0;i<str->Length;i++)
      wcout<<(wchar_t)str->Buffer[i];
  wcout.clear();
}

int main()
{
  // NtQuerySystemInformation resides in ntdll.dll
  HINSTANCE hNtDll=GetModuleHandle("ntdll.dll");
  if(hNtDll==0)
    {
      cout <<"ntdll.dll error"<<endl;
      return 1;
    }

  // Initialise function pointer
  FP_NTQUERYSYSTEMINFORMATION NtQuerySystemInformation=
      (FP_NTQUERYSYSTEMINFORMATION)GetProcAddress(hNtDll, "NtQuerySystemInformation");

  if(NtQuerySystemInformation==0)
    {
      cout <<"Could not get address of NtQuerySystemInformation"<<endl;
      return 1;
    }


  char *buffer;
  ULONG buffer_size,
        bytes_returned,
        ret;             // function return value

  //
  // Just allocate 1MB of memory and don't care about how much of it will be actually used
  // Well, I know there must be a better soliution...
  //
    buffer_size=1024*1024;
    buffer = new char[buffer_size];

    ret=NtQuerySystemInformation(SystemProcessInformation, buffer, buffer_size, &bytes_returned);

    if(ret!=STATUS_SUCCESS)
      {
        cout <<"NtQuerySystemInformation error ("<<ret<<")"<<endl;
        return ret;
      }


   SYSTEM_PROCESS_INFORMATION *spi=(SYSTEM_PROCESS_INFORMATION *)buffer;

  //
  // Print some information
  //
  cout<<"  PID  Parent PID   Handle count  VM pages   Base Priority   Image Name"<<endl;
  cout<<"-----------------------------------------------------------------------"<<endl;
   do
   {
      cout <<setw(5)<<(unsigned)spi->ProcessId;
      cout <<setw(10)<<(unsigned)spi->InheritedFromProcessId;
      cout <<setw(9)<<(unsigned)spi->HandleCount;
      cout <<setw(18)<<(unsigned)spi->PrivatePageCount;
      cout <<setw(8)<<(unsigned)spi->BasePriority;

      cout <<setw(5)<<' ';
      PrintUnicodeString(&spi->ImageName);

      cout <<endl;

     spi = (SYSTEM_PROCESS_INFORMATION*)((void*)spi + spi->NextEntryOffset);
   }while(spi->NextEntryOffset!=0);

}
