// Source code demonstration created by Michael Haephrati
// haephrati@gmail.com http://www.haephrati.com
// Purpose of this demonstration: Locate the default Skype account name
// Created on: October 2014
#include "main.h"
#include "functions.h"
bool GetNodeByElementName(rapidxml::xml_node<char>* start_node, char* chElement, rapidxml::xml_node<char>** result_node)
{
	if (start_node == 0)
		return false;
	if (_stricmp(chElement, start_node->name()) == 0)
	{
		(*result_node) = start_node;
		return true;
	}
	if (GetNodeByElementName(start_node->first_node(), chElement, result_node) == true)
		return true;
	else if (GetNodeByElementName(start_node->next_sibling(), chElement, result_node) == true)
		return true;

	return false;
}

bool GetSkypeDefaultAccount(TCHAR *result)
{
	TCHAR szFileName[MAX_PATH + 1];
	SHGetSpecialFolderPath(0, szFileName, CSIDL_APPDATA, 0);

	// First we need to get the Skype account ID
	StrCat(szFileName, _T("\\Skype\\shared.xml"));		// This file holdes among other data, the default user ID

	FILE *fp;
	char *xmlData = NULL;
	int fileSize = 0;
	errno_t err;

	// Open for read (will fail if file "crt_fopen_s.c" does not exist)
	err = _wfopen_s(&fp,szFileName, _T("rb"));
	if (err == NULL)
	{
		fseek(fp, 0L, SEEK_END);
		fileSize = ftell(fp);
		// Allocate the read buffer
		xmlData = (char*)malloc(sizeof(char)*(fileSize + 1));
		rewind(fp);
		// Read the file's data into the read buffer
		long read = fread(xmlData, sizeof(char), fileSize, fp);
		xmlData[fileSize] = '\0';
		fclose(fp);
	}
	// ==============
	rapidxml::xml_document<char> doc;
	doc.parse<0>(xmlData);
	rapidxml::xml_node<char>* root = doc.first_node();
	//printf("%s\n", root->name());

	rapidxml::xml_node<char>* node_account = 0;
	if (GetNodeByElementName(root, "Account", &node_account) == true)
	{
		rapidxml::xml_node<char>* node_default = 0;
		if (GetNodeByElementName(node_account, "default", &node_default) == true)
		{
			swprintf(result, 100, L"%hs", node_default->value());
			free(xmlData);
			return true;
		}
	}

	free(xmlData);
	return false;
}
